function [yy] = eccatenaria(C,y)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% funcion ECCATENARIA
%
% yy = eccatenaria(C,y)
%
% Proporciona la ecuacion diferencial de una cuerda suspendida entre
% dos puntos en forma de dos ecuaciones diferenciales de primer orden
%
% y1' = y2
% y2' = C*sqrt(1+y2)
%
% ENTRADAS: 
%            y  : un vector de dos elementos, con los valores de la 
%                 coordenada y y su derivada y': [y y'].
%            C  : la constante de la cuerda, igual a la densidad de masa
%                 por la aceleracion de la gravedad  entre la tension
%                 horizontal
%
% salida : un array de dos elementos con los valores de las derivadas 
%          evaluadas en los valores de entrada y: [y' y'']
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
yy = [ y(2); C*sqrt( 1 + (y(2))^2 ) ];
